﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class UserAccountDB
    {
        public static UserAccount GetItem(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserName", (string.IsNullOrEmpty(userName) ? (object)DBNull.Value : userName)));
            parameters.Add(new SqlParameter("@UPassword", (string.IsNullOrEmpty(password) ? (object)DBNull.Value : password)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<UserAccount>("spGetUserAccount", parameters);
        }
        public static void Delete(Guid UserAccID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@UserAccountID", UserAccID != null && UserAccID != Guid.Empty ? UserAccID : (object)DBNull.Value));
            SQLHelper.ExecuteQuery("spRemoveUserAccount", parameters);
        }

        public static void DeleteLocal()
        {
            //if (GlobalConfigurations.AppConfiguration.IsLocalDatabase)
            //{
            string SQL = string.Empty;
            SQL = @"DELETE FROM UserAccount Where UserRoleType='User'";
            SQLHelper.ExecuteQueryStatement(SQL.ToString());
            //}
        }

        public static List<UserAccount> GetList(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserName", (string.IsNullOrEmpty(userName) ? (object)DBNull.Value : userName)));
            parameters.Add(new SqlParameter("@UPassword", (string.IsNullOrEmpty(password) ? (object)DBNull.Value : password)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));
            return SQLHelper.RetrieveList<UserAccount>("spGetUserAccount", parameters);
        }

        public static List<UserAccount> GetOfflineList(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserName", (string.IsNullOrEmpty(userName) ? (object)DBNull.Value : userName)));
            parameters.Add(new SqlParameter("@UPassword", (string.IsNullOrEmpty(password) ? (object)DBNull.Value : password)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));
            return SQLHelper.RetrieveOfflineList<UserAccount>("spGetUserAccount", parameters);
        }

        public static DataTable GetDataTable(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            //if (GlobalConfigurations.AppConfiguration.IsConnectedToInternet())
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserName", (string.IsNullOrEmpty(userName) ? (object)DBNull.Value : userName)));
            parameters.Add(new SqlParameter("@UPassword", (string.IsNullOrEmpty(password) ? (object)DBNull.Value : password)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));
            return SQLHelper.ExecuteDataTable("spGetUserAccount", parameters);
        }

        public static DataSet GetDataSet(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            //if (GlobalConfigurations.AppConfiguration.IsConnectedToInternet())
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserName", (string.IsNullOrEmpty(userName) ? (object)DBNull.Value : userName)));
            parameters.Add(new SqlParameter("@UPassword", (string.IsNullOrEmpty(password) ? (object)DBNull.Value : password)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));
            return SQLHelper.ExecuteDataSet("spGetUserAccount", parameters);
        }

        public static void Save(UserAccount myUser)
        {
            myUser.Mode = ((myUser.UniqueID != Guid.Empty && myUser.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myUser.UniqueID = ((myUser.UniqueID != Guid.Empty && myUser.UniqueID != null) ? myUser.UniqueID : Guid.NewGuid());
            if (myUser.Mode == GlobalConfigurations.Mode.Insert)
            {
                myUser.IsActive = true;
            }
            //if (GlobalConfigurations.AppConfiguration.IsConnectedToInternet())
            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@UserAccountID", myUser.UniqueID));
            parameters.Add(new SqlParameter("@UserName", myUser.UserName));
            parameters.Add(new SqlParameter("@UPassword", myUser.UPassword));
            parameters.Add(new SqlParameter("@Email", (string.IsNullOrEmpty(myUser.Email) ? (object)DBNull.Value : myUser.Email)));
            parameters.Add(new SqlParameter("@Salutation", (string.IsNullOrEmpty(myUser.Salutation) ? (object)DBNull.Value : myUser.Salutation)));
            parameters.Add(new SqlParameter("@FirstName", (string.IsNullOrEmpty(myUser.FirstName) ? (object)DBNull.Value : myUser.FirstName)));
            parameters.Add(new SqlParameter("@LastName", (string.IsNullOrEmpty(myUser.LastName) ? (object)DBNull.Value : myUser.LastName)));
            parameters.Add(new SqlParameter("@Gender", (string.IsNullOrEmpty(myUser.Gender) ? (object)DBNull.Value : myUser.Gender)));
            parameters.Add(new SqlParameter("@MobileNo", (string.IsNullOrEmpty(myUser.MobileNo) ? (object)DBNull.Value : myUser.MobileNo)));
            parameters.Add(new SqlParameter("@PhoneNo", (string.IsNullOrEmpty(myUser.PhoneNo) ? (object)DBNull.Value : myUser.PhoneNo)));
            parameters.Add(new SqlParameter("@DOB", (myUser.DOB == DateTime.MinValue ? (object)DBNull.Value : myUser.DOB)));
            parameters.Add(new SqlParameter("@Occupation", (string.IsNullOrEmpty(myUser.Occupation) ? (object)DBNull.Value : myUser.Occupation)));
            parameters.Add(new SqlParameter("@Address1", (string.IsNullOrEmpty(myUser.Address1) ? (object)DBNull.Value : myUser.Address1)));
            parameters.Add(new SqlParameter("@Address2", (string.IsNullOrEmpty(myUser.Address2) ? (object)DBNull.Value : myUser.Address2)));
            parameters.Add(new SqlParameter("@City", (string.IsNullOrEmpty(myUser.City) ? (object)DBNull.Value : myUser.City)));
            parameters.Add(new SqlParameter("@StateProvince", (string.IsNullOrEmpty(myUser.StateProvince) ? (object)DBNull.Value : myUser.StateProvince)));
            parameters.Add(new SqlParameter("@Country", (string.IsNullOrEmpty(myUser.Country) ? (object)DBNull.Value : myUser.Country)));
            parameters.Add(new SqlParameter("@PostalCode", (string.IsNullOrEmpty(myUser.PostalCode) ? (object)DBNull.Value : myUser.PostalCode)));
            //parameters.Add(new SqlParameter("@ShippingAddress1", (string.IsNullOrEmpty(myUser.ShippingAddress1) ? (object)DBNull.Value : myUser.ShippingAddress1)));
            //parameters.Add(new SqlParameter("@ShippingAddress2", (string.IsNullOrEmpty(myUser.ShippingAddress2) ? (object)DBNull.Value : myUser.ShippingAddress2)));
            //parameters.Add(new SqlParameter("@ShippingCity", (string.IsNullOrEmpty(myUser.ShippingCity) ? (object)DBNull.Value : myUser.ShippingCity)));
            //parameters.Add(new SqlParameter("@ShippingStateProvince", (string.IsNullOrEmpty(myUser.ShippingStateProvince) ? (object)DBNull.Value : myUser.ShippingStateProvince)));
            //parameters.Add(new SqlParameter("@ShippingCountry", (string.IsNullOrEmpty(myUser.ShippingCountry) ? (object)DBNull.Value : myUser.ShippingCountry)));
            //parameters.Add(new SqlParameter("@ShippingPostalCode", (string.IsNullOrEmpty(myUser.ShippingPostalCode) ? (object)DBNull.Value : myUser.ShippingPostalCode)));
            parameters.Add(new SqlParameter("@CustomerType", (string.IsNullOrEmpty(myUser.CustomerType) ? (object)DBNull.Value : myUser.CustomerType)));
            parameters.Add(new SqlParameter("@DiscountType", (string.IsNullOrEmpty(myUser.DiscountType) ? (object)DBNull.Value : myUser.DiscountType)));
            parameters.Add(new SqlParameter("@DiscountValue", (myUser.DiscountValue == 0 ? (object)DBNull.Value : myUser.DiscountValue)));
            parameters.Add(new SqlParameter("@UserRoleType", (string.IsNullOrEmpty(myUser.UserRoleType) ? (object)DBNull.Value : myUser.UserRoleType)));
            parameters.Add(new SqlParameter("@IsApproved", myUser.IsApproved));
            parameters.Add(new SqlParameter("@IsActive", myUser.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myUser.IsDeleted));
            parameters.Add(new SqlParameter("@AdminUserAccountID", ((myUser.AdminUserAccountID != Guid.Empty && myUser.AdminUserAccountID != null) ? myUser.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Mode", myUser.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdateUserAccount", parameters);
            //parameters.Add(new SqlCeParameter("@ShippingAddress1", (string.IsNullOrEmpty(myUser.ShippingAddress1) ? (object)DBNull.Value : myUser.ShippingAddress1)));
            //parameters.Add(new SqlCeParameter("@ShippingAddress2", (string.IsNullOrEmpty(myUser.ShippingAddress2) ? (object)DBNull.Value : myUser.ShippingAddress2)));
            //parameters.Add(new SqlCeParameter("@ShippingCity", (string.IsNullOrEmpty(myUser.ShippingCity) ? (object)DBNull.Value : myUser.ShippingCity)));
            //parameters.Add(new SqlCeParameter("@ShippingStateProvince", (string.IsNullOrEmpty(myUser.ShippingStateProvince) ? (object)DBNull.Value : myUser.ShippingStateProvince)));
            //parameters.Add(new SqlCeParameter("@ShippingCountry", (string.IsNullOrEmpty(myUser.ShippingCountry) ? (object)DBNull.Value : myUser.ShippingCountry)));
            //parameters.Add(new SqlCeParameter("@ShippingPostalCode", (string.IsNullOrEmpty(myUser.ShippingPostalCode) ? (object)DBNull.Value : myUser.ShippingPostalCode)));
            //parameters.Add(new SqlCeParameter("@IsDeleted", myUser.IsDeleted));

        }



    }
}
